﻿using UnityEngine;
using System.Collections;
using System.Text.RegularExpressions;	// 正規表現のパッケージを読み込む

public class autonews : MonoBehaviour {
	string[] title;	// ニュースRSSのタイトルを格納する
	string[] image;	// ニュースRSSの画像のURLを格納する
	int numitem;	// ニュース項目の数
	tvmlengine teg; // TVML SDKのインスタンス

	void Start () {
		title = new string[100];
		image = new string[100];
		teg = GetComponent<tvmlengine>();
		teg.initialize(); 
		teg.setPlayerViewPortRect(0, 0, 1, 1);
	}
	
	void Update () {
	}

	void OnGUI()
	{
		if (GUI.Button (new Rect (10, 10, 50, 20), "PLAY")) {
			WWW www = new WWW ("http://rss.rssad.jp/rss/zakzak/all/zakzak-all.xml");	// ZAKZAKの芸能ニュースRSSのURLをアクセス
			while (!www.isDone) {	// 全部読み込まれるまで待つ
			}
			string txt = www.text;	// XMLテキストを取得する

			readHtml(txt);	// XMLを解析する

			string tvml = makeTvml();	// XML解析結果からTVMLスクリプトを生成する

			teg.playScript(tvml);	// TVMLスクリプトを再生する
		}
	}

	// 正規表現を使ってRSSのXMLを解析し、ニュース項目の「タイトル」と「画像のURL」を抽出する
	void readHtml(string intext)
	{
		int i = 0;
		foreach (Match m in Regex.Matches(intext, "<item>(.*?)</item>", RegexOptions.IgnoreCase | RegexOptions.Singleline))	// itemタグの内容を取得する（大文字小文字区別なし、改行を無視）
		{
			string textitem = m.Groups[1].Value;
			Match mm = Regex.Match(textitem, "<title>(.*?)</title>", RegexOptions.IgnoreCase | RegexOptions.Singleline);	// titleタグの内容を取得する
			Match mmm = Regex.Match(textitem, "<enclosure\\s*url\\s*=\\s*\"(.*?)\"\\s*.*?>", RegexOptions.IgnoreCase | RegexOptions.Singleline);	// <enclosure url = "（URL）">というパターンでサーチしてURLを取得する
			title[i] = mm.Groups[1].Value;
			image[i] = mmm.Groups[1].Value;
			i++;
			//Debug.Log(mmm.Groups[1].Value);
		}
		numitem = i;
	}

	// ニュース項目の「タイトル」と「画像のURL」を使って、TVMLスクリプトを生成する
	string makeTvml()
	{
		string tvml;

		tvml = makeTvmlInit();	// TVMLスクリプトの初期化部分を作る

		for(int i=0 ; i<numitem ; i++)	{
			string imageplatename = "Imgplt" + i.ToString();
			tvml += "prop: openimageplate( name=" + imageplatename + ", filename=\"" + image[i] + "\", hsize=1.2, vsize=0.9, aspect=fit )\n";
			tvml += "prop: position( name=" + imageplatename + ", x=0.5, y=1.0, z=-0.5, rx=0.00, ry=0.00, rz=0.00, scale=1.3 )\n";
			tvml += "prop: visible( name=" + imageplatename + ", switch=on )\n";
			tvml += "character: mocap(name=A, motion=I17, jointignored=LowerBody, wait=no)\n";
			tvml += "character: talk(name=A, text=\"" + title[i] + "\", lipsync=3.0)\n";
			tvml += "prop: visible( name=" + imageplatename + ", switch=off )\n";
		}

		return tvml;
	}

	// TVMLスクリプトの初期化部分を作る
	string makeTvmlInit()
	{
		string val;

		val = "";
		val += "skipscript( switch=on )\n";
		val += "prop:openmodel(name=normal, filename=\"Setprops/newnormal/newnormal\")\n";
		val += "prop: position(name=normal, x=0.0, y=0.0, z=0.0, rx=0.0, ry=0.0, rz=0.0, scale=1.0)\n";
		val += "character: openmodel( model=BOB, filename=\"Characters/Bob/Bob\" )\n";
		val += "character: casting( name=A, model=BOB )\n";
		val += "character: setvoice(name=A, voicetype=\"VoiceSommelier:Voice10\")\n";
		val += "character: position( name=A, x=0.0, y=0.0, z=0.0, rx=0.00, ry=0.00, rz=0.00, posture=standing )\n";
		val += "character: blink(name=A, frequency=1.5)\n";
		val += "character: swing(name=A, degree=1, speed=2)\n";
		val += "character: gesture(name=A, switch=off)\n";		
		val += "character: definepose(name=A, pose=def, joint=LeftLowerArm, rx=0)\n";
		val += "character: definepose(name=A, pose=def, joint=RightLowerArm, rx=0)\n";
		val += "character: pose(name=A, pose=def)\n";		
		val += "character: openmocap(motion=I17, filename=\"BVHs/I17\")\n";
		val += "camera: position(name=Cam, x=0.274, y=0.9, z=1.0, rx=-0.0, ry=180.0, rz=0.0, vangle=50.0)\n";
		val += "camera: switch(name=Cam)\n";
		val += "light: flat(name=no1, r=0.5, g=0.5, b=0.5, vx=1.00, vy=-1.00, vz=-1.00)\n";
		val += "light: flat(name=no2, r=0.5, g=0.5, b=0.5, vx=-1.00, vy=-1.00, vz=-1.00)\n";
		val += "setcaption(fontsize=22, y=-40%, width=85%, height=20%, border=on, borderwidth=2, bordercolor=#ffffff, color=#ff0000)\n";
		val += "character: look(name=A, target=camera)\n";
		val += "skipscript( switch=off )\n";
		val += "//! ==========================initializeEnd\n";
		
		return val;
	}
}
