﻿using UnityEngine;
using System.Collections;
#if UNITY_EDITOR
using UnityEditor;
#endif

public class tvmlplayer : MonoBehaviour {
	public class Settings
	{
		private string _text;
		private int _number;
		
		public string Text
		{
			get {return _text;}
			set {_text = value;}
		}
		public int Number
		{
			get {return _number;}
			set {_number = value;}
		}
		
		public Settings()
		{
			_text = "Text";
			_number = 0;
		}
	}
	private tvmlengine teg; 
	private string text; 
	string path;
	string fntvml;
	int	flagplaypause;
	bool flagpause, flagstop, flagfileload;
	Settings appSettings;
	string settingfileName;	
	public Texture btnplay, btnstop, btnpause, btnfile, btnlog;
	float	volume;
    static string logfilename;

	int	wwidth, wheight;
	int btnx, btny;
	void Awake()	{
		wwidth = 883;	// 670 (640x360) // 1030 (1000x563) // 830 // 883 (853x480) = YouTubeのサイズ
		wheight = (int)( (9.0f/16.0f)*(wwidth-30.0f)+55.0f );	// width=883のとき535
		Screen.SetResolution(wwidth, wheight, false);
	}
	void Start () {
	    teg = GetComponent<tvmlengine>(); // エンジン取得        
	    teg.initialize();  // 初期化
		float wtmp = wwidth - 30;
		teg.setPlayerViewPortRect(15.0f/wwidth, 40.0f/wheight, wtmp/wwidth, (wtmp*9.0f/16.0f)/wheight); // 描画領域 aspect ratio = 16:9
		btnx = 15;
		btny = wheight - 30;

		flagplaypause = 0;
		flagpause = false;
		flagstop = true;
		flagfileload = false;

		path = System.Environment.GetFolderPath (System.Environment.SpecialFolder.Desktop);
		appSettings = new Settings();	
		string fn = System.IO.Path.GetTempPath();
		settingfileName = fn + "\\tvmlplayerSettings.log";	
		if(System.IO.File.Exists(settingfileName))	{
			readsetting ();
			path = appSettings.Text;
		}
		string fnlog = System.IO.Path.GetTempPath () + "\\" + "tvmlplayerLog.txt";
		System.IO.File.Delete(fnlog);
		System.IO.StreamWriter sw = new System.IO.StreamWriter(fnlog);
		sw.Close ();
		logfilename = System.IO.Path.GetTempPath();
		logfilename = logfilename + "/tvmlplayerLog.txt";

		AudioListener.volume = 1;
		volume = 1.0f;
	}

	void Update()    {
		if( Input.GetKey(KeyCode.A))	
        {
        }
	}

	IEnumerator playscript()
	{		 
		WWW www = new WWW("file:///" + fntvml);
		while(!www.isDone) {}
		text = www.text;
		path = System.IO.Path.GetDirectoryName(fntvml);
		teg.setDataSearchPath(path + "/");
		teg.playScript(text);
		yield return 0;
	}
	
	void OnGUI()
	{
		if (flagplaypause == 0) 
		{	
			if(GUI.Button(new Rect(btnx, btny, 70, 20), btnplay))	{
				if(flagpause == true)	{
					teg.play ();
					flagpause = false;
					flagplaypause = 1;
				}
				else {
					if(flagstop && flagfileload)	{
						StartCoroutine(playscript());
						flagpause = false;
						flagplaypause = 1;
					}
				}
			}
		}
		else if (flagplaypause == 1)
		{	
			if(GUI.Button(new Rect(btnx, btny, 70, 20), btnpause))	{
				teg.pause();
				flagplaypause = 0;
				flagpause = true;
			}
		}
		if (flagfileload == true) {
			if (GUI.Button (new Rect (btnx + 80, btny, 70, 20), btnstop)) {			
								teg.stop ();
								flagstop = true;
								flagpause = false;
								flagplaypause = 0;
						}
				}
		else 
			GUI.Button (new Rect (btnx + 80, btny, 70, 20), btnstop);

		if (GUI.Button (new Rect (btnx + 160, btny, 70, 20), btnfile)) 
		{			
#if UNITY_EDITOR
			fntvml = EditorUtility.OpenFilePanel ("Select TVML file", path, "txt");
#else
			System.Windows.Forms.OpenFileDialog openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			System.IO.Stream myStream = null;

			openFileDialog1.InitialDirectory = path;
			openFileDialog1.Filter = "txt files (*.txt)|*.txt|All files (*.*)|*.*" ;
			openFileDialog1.FilterIndex = 2 ;
			openFileDialog1.RestoreDirectory = true ;
			
			if(openFileDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK)
			{
				try
				{
					fntvml =  openFileDialog1.FileName;
				}
				catch (System.Exception ex)
				{
					Debug.Log("dialogerror");//MessageBox.Show("Error: Could not read file from disk. Original error: " + ex.Message);
				}
			}
#endif

			if(fntvml.Length != 0)	{
				if(teg.getStatusPlay())	teg.stop ();
				flagfileload = true;
				flagstop = true;
				flagpause = false;
				flagplaypause = 0;
				appSettings.Text = System.IO.Path.GetDirectoryName(fntvml);
				writesetting();
			}
		}

/*
    Unity5.3.4になって下記のエラーが出るようになったので削除した（とりあえず）
        Assets/applications/tvmlplayer.cs(174,52): error CS0120: An object
        reference is required to access non-static member
        `System.Diagnostics.Process.Start()'
*/
		if (GUI.Button(new Rect(btnx + 280, btny, 50, 20), btnlog))
		{	
			System.Diagnostics.Process.Start("notepad.exe", logfilename);
		}


		volume = GUI.HorizontalSlider(new Rect(btnx + 600, btny+5, 100, 20), volume, 0, 1);
		AudioListener.volume = volume;
	}
	

	void writesetting()
	{
		System.Xml.Serialization.XmlSerializer serializer1 =
			new System.Xml.Serialization.XmlSerializer(typeof(Settings));
		System.IO.StreamWriter sw = new System.IO.StreamWriter(settingfileName, false, new System.Text.UTF8Encoding(false));
		serializer1.Serialize(sw, appSettings);
		sw.Close();
	}

	void readsetting()
	{
		System.Xml.Serialization.XmlSerializer serializer2 =
			new System.Xml.Serialization.XmlSerializer(typeof(Settings));
		System.IO.StreamReader sr = new System.IO.StreamReader(settingfileName, new System.Text.UTF8Encoding(false));
		appSettings = (Settings)serializer2.Deserialize(sr);
		sr.Close();
	}

}
